<?php
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_articles/tmpl/documentos/css/style.css');

if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}
?>

<div class="uk-padding-large">
    <?php foreach ($items as $item) : ?>
    <?php
        $fields = FieldsHelper::getFields('com_content.article', $item, true);
        $rowsData = [];

        foreach ($fields as $field) {
            if ($field->name === 'multimedia-archivos') {
                $rows = json_decode($field->rawvalue, true);
                if (is_array($rows)) {
                    $rowsData = $rows;
                }
            }
        }

        if (empty($rowsData)) {
            continue;
        }
        ?>

    <ul class="uk-flex uk-flex-center <?php echo $gridCols; ?>" uk-grid>
        <?php foreach ($rowsData as $row) :
                $titulo = trim($row['field1'] ?? '');
                $ruta   = trim($row['field2'] ?? '');

                if (empty($ruta)) {
                    continue;
                }

                $href = (strpos($ruta, 'http') === 0) ? $ruta : Uri::root() . ltrim($ruta, '/');
                ?>
        <li class="uk-width-1-4@l uk-width-1-4@m uk-width-1-2@s uk-text-center">
            <a title="<?php echo htmlspecialchars($titulo); ?>" href="<?php echo htmlspecialchars($href); ?>"
                class="content-book-link" download>
                <div class="content-book">
                    <div class="book">
                        <div class="paper"></div>
                        <div class="cover">
                            <div class="title">
                                <h3><?php echo htmlspecialchars($titulo); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </a>
            <span></span>
        </li>
        <?php endforeach; ?>
    </ul>

    <?php endforeach; ?>
</div>